<?php 
$pageTitle = 'Web Development';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">Web Development</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Creamos ecosistemas digitales de alto rendimiento con las tecnologías más modernas del mercado.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16 items-center">
                <div>
                    <h2 class="text-3xl font-bold mb-6">Tecnologías Full-Stack</h2>
                    <p class="text-gray-400 text-lg leading-relaxed mb-6">Nuestro stack está diseñado para la velocidad. Utilizamos React y Next.js para el frontend, y Node.js o Python para el backend, asegurando escalabilidad y eficiencia en cada línea de código.</p>
                    <ul class="space-y-4">
                        <li class="flex items-center gap-3"><i class="fa-solid fa-check text-brand-orange"></i> Single Page Applications (SPA)</li>
                        <li class="flex items-center gap-3"><i class="fa-solid fa-check text-brand-orange"></i> Progressive Web Apps (PWA)</li>
                        <li class="flex items-center gap-3"><i class="fa-solid fa-check text-brand-orange"></i> E-commerce de alta conversión</li>
                        <li class="flex items-center gap-3"><i class="fa-solid fa-check text-brand-orange"></i> Paneles de administración a medida</li>
                    </ul>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div class="p-6 bg-[#0a0a0a] border border-white/10 rounded-2xl flex flex-col items-center">
                        <i class="fa-brands fa-react text-5xl text-blue-400 mb-4"></i>
                        <span class="font-bold">React</span>
                    </div>
                    <div class="p-6 bg-[#0a0a0a] border border-white/10 rounded-2xl flex flex-col items-center">
                        <i class="fa-brands fa-node-js text-5xl text-green-500 mb-4"></i>
                        <span class="font-bold">Node.js</span>
                    </div>
                    <div class="p-6 bg-[#0a0a0a] border border-white/10 rounded-2xl flex flex-col items-center">
                        <i class="fa-brands fa-python text-5xl text-yellow-500 mb-4"></i>
                        <span class="font-bold">Python</span>
                    </div>
                    <div class="p-6 bg-[#0a0a0a] border border-white/10 rounded-2xl flex flex-col items-center">
                        <i class="fa-brands fa-js-square text-5xl text-yellow-400 mb-4"></i>
                        <span class="font-bold">TypeScript</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
