<?php 
$pageTitle = 'Portafolio';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">Casos de Éxito</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Resultados reales. Transformaciones digitales que han generado impacto medible en nuestros clientes.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Case Study: Zaha360 -->
                <div class="group relative rounded-2xl overflow-hidden border border-white/10 bg-[#111]">
                    <div class="aspect-video bg-gray-900 group-hover:scale-105 transition-transform duration-500 relative">
                        <div class="absolute inset-0 flex items-center justify-center text-4xl font-bold text-gray-800">ZAHA360</div>
                    </div>
                    <div class="p-8">
                        <div class="text-brand-orange text-xs font-bold uppercase tracking-widest mb-2">Producto Propio</div>
                        <h3 class="text-2xl font-bold mb-3">Zaha360 System</h3>
                        <p class="text-gray-400 text-sm mb-6">Plataforma integral SaaS para Horeca y Retail con POS, Inventarios y Facturación.</p>
                        <a href="zaha360.php" class="text-white border-b border-brand-orange pb-1 hover:text-brand-orange transition-colors font-bold uppercase text-xs tracking-wider">Ver Caso Completo</a>
                    </div>
                </div>

                <!-- Case Study: Generic -->
                <div class="group relative rounded-2xl overflow-hidden border border-white/10 bg-[#111]">
                    <div class="aspect-video bg-gray-900 group-hover:scale-105 transition-transform duration-500 relative">
                         <div class="absolute inset-0 flex items-center justify-center text-4xl font-bold text-gray-800">E-COMMERCE</div>
                    </div>
                    <div class="p-8">
                        <div class="text-brand-orange text-xs font-bold uppercase tracking-widest mb-2">Desarrollo Web</div>
                        <h3 class="text-2xl font-bold mb-3">Moda Internacional</h3>
                        <p class="text-gray-400 text-sm mb-6">E-commerce de alto rendimiento con pasarela de pagos personalizada y gestión de stock en tiempo real.</p>
                        <a href="#" class="text-white border-b border-brand-orange pb-1 hover:text-brand-orange transition-colors font-bold uppercase text-xs tracking-wider">Ver Detalles</a>
                    </div>
                </div>
            </div>

            <div class="mt-20 text-center">
                <a href="portafolio.pdf" target="_blank" class="inline-block px-10 py-4 border border-white/20 rounded-xl text-white font-bold uppercase tracking-wider hover:bg-white/5 transition-colors">
                    <i class="fa-solid fa-download mr-2"></i> Descargar Portafolio PDF
                </a>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
