<?php 
$pageTitle = 'Mobile Apps';
include 'includes/header.php';
?>

    <header class="pt-48 pb-24 bg-brand-surface border-b border-white/5 relative overflow-hidden">
        <div class="absolute top-0 right-0 w-1/2 h-full bg-brand-orange/5 blur-[100px] rounded-full pointer-events-none"></div>
        <div class="max-w-7xl mx-auto px-4 text-center relative z-10">
            <h1 class="text-5xl md:text-7xl font-black mb-6">Mobile Apps</h1>
            <p class="text-xl text-gray-400 max-w-2xl mx-auto">Experiencias nativas en el bolsillo de sus clientes. Soluciones móviles fluidas y potentes.</p>
        </div>
    </header>

    <section class="py-24">
        <div class="max-w-7xl mx-auto px-4">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-16 items-center">
                <div class="order-2 md:order-1 flex justify-center">
                    <div class="w-64 h-[500px] bg-[#111] border-8 border-[#222] rounded-[3rem] relative overflow-hidden shadow-2xl">
                        <div class="absolute top-0 left-1/2 -translate-x-1/2 w-24 h-6 bg-[#222] rounded-b-2xl"></div>
                        <div class="absolute inset-0 flex items-center justify-center p-6 text-center">
                            <div>
                                <i class="fa-solid fa-mobile-screen text-4xl text-brand-orange mb-4"></i>
                                <h4 class="font-bold mb-2">Biknova Mobile</h4>
                                <p class="text-[10px] text-gray-500">Premium Experiences</p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="order-1 md:order-2">
                    <h2 class="text-3xl font-bold mb-6">Cross-Platform Excellence</h2>
                    <p class="text-gray-400 text-lg leading-relaxed mb-6">Desarrollamos una única base de código para iOS y Android utilizando Flutter o React Native, lo que reduce costos de mantenimiento y acelera el tiempo de lanzamiento sin comprometer el rendimiento.</p>
                    <div class="space-y-4">
                        <div class="flex items-start gap-4 p-4 rounded-xl bg-white/5 border border-white/10">
                            <i class="fa-solid fa-rocket text-brand-orange mt-1"></i>
                            <div>
                                <h4 class="font-bold">Rendimiento Nativo</h4>
                                <p class="text-sm text-gray-500">Animaciones a 60fps y acceso total al hardware.</p>
                            </div>
                        </div>
                        <div class="flex items-start gap-4 p-4 rounded-xl bg-white/5 border border-white/10">
                            <i class="fa-solid fa-bell text-brand-orange mt-1"></i>
                            <div>
                                <h4 class="font-bold">Notificaciones Push</h4>
                                <p class="text-sm text-gray-500">Engage a sus usuarios en el momento preciso.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php include 'includes/footer.php'; ?>
