<?php
header('Content-Type: application/json');
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nombre = $_POST['nombre'] ?? '';
    $email = $_POST['email'] ?? '';
    $whatsapp = $_POST['whatsapp'] ?? '';
    $proyecto = $_POST['proyecto'] ?? '';

    if (empty($nombre) || empty($email) || empty($whatsapp) || empty($proyecto)) {
        echo json_encode(['status' => 'error', 'message' => 'Todos los campos son obligatorios.']);
        exit;
    }

    try {
        $stmt = $pdo->prepare("INSERT INTO leads (nombre, email, whatsapp, proyecto) VALUES (?, ?, ?, ?)");
        $stmt->execute([$nombre, $email, $whatsapp, $proyecto]);
        
        echo json_encode(['status' => 'success', 'message' => '¡Proyecto recibido! Nos contactaremos pronto.']);
    } catch (Exception $e) {
        echo json_encode(['status' => 'error', 'message' => 'Error al guardar: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido.']);
}
?>
